local t = Def.ActorFrame{}
t[#t+1] = SquareFont()..{InitCommand=cmd(x,200;draworder,1); OnCommand=HeaderCommand();};
local timercountdown = MetroQuad.Global.MiscOptions.TimerCountDownStart
t[#t+1] = LoadActor("_MenuTimer",timercountdown)..{InitCommand=cmd(draworder,1;xy,CenterX(),Top()+56;)}

-- Timer Frame
t[#t+1] = Def.ActorFrame{
	Def.Quad{InitCommand=cmd(draworder,-20;x,CenterX()-70;y,Top()+40;rotationz,-16;zoomto,12,94;diffuse,color("#000000");zwrite,true;blend,'BlendMode_NoEffect');};
	Def.Quad{InitCommand=cmd(draworder,-20;x,CenterX()+70;y,Top()+40;rotationz,16;zoomto,12,94;diffuse,color("#000000");zwrite,true;blend,'BlendMode_NoEffect');};
	Def.Quad{InitCommand=cmd(x,CenterX();y,Top()+40;setsize,128,32;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3);vertalign,top;zwrite,true;ztest,true);};
};

-- If we change the Game from the option row "OptionRowSwitchGame()"
-- the Theme will set MetroQuad.Global.MiscOptions.GameChangedFromOpList to true
-- and "ScreenSelectQuickProfile" will be loaded as the next screen.
-- We must set a style depending of the number of sides joined.
local function setStyle()
	local numSides = GAMESTATE:GetNumSidesJoined()
	local techno = GAMESTATE:GetCurrentGame():GetName() == "techno"
	
	if techno then
		GAMESTATE:UnjoinPlayer(PLAYER_1)
		GAMESTATE:UnjoinPlayer(PLAYER_2)
		if numSides == 0 then
			return GAMESTATE:SetCurrentStyle("Single8")
		else
			return GAMESTATE:SetCurrentStyle("Double8")
		end
	else
		if numSides == 0 then
			return GAMESTATE:SetCurrentStyle("Single")
		else
			return GAMESTATE:SetCurrentStyle("Versus")
		end
	end
end
setStyle()

local function input(event)
	local pn = event.PlayerNumber
	local techno = GAMESTATE:GetCurrentGame():GetName() == "techno"
	local numSides = GAMESTATE:GetNumSidesJoined()
	if event.type == "InputEventType_Release" then return false end
	
	if event.GameButton == "Select" then
		if GAMESTATE:GetNumSidesJoined() > 0 then
			SCREENMAN:GetTopScreen():SetNextScreenName("ScreenOptionsManageProfilesQuickTemporaly")
			SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
		end
	end
	
	-- Weirds things happens when we change of Game from the OptionRow,
	-- in the case of Techno and seeing that the style versus8 is not
	-- available in this Theme, the opposite player that pressed START
	-- will unjoin and the style will set to single8.
	-- The style can be changed later via OptionsList.	
	if techno then
		if pn == PLAYER_1 then
			if event.GameButton == "Start" then
				if numSides > 1 then
					GAMESTATE:UnjoinPlayer(PLAYER_2)
					GAMESTATE:SetCurrentStyle("Single8")
				end
			end
		end
		if pn == PLAYER_2 then
			if event.GameButton == "Start" then
				if numSides > 1 then
					GAMESTATE:UnjoinPlayer(PLAYER_1)
					GAMESTATE:SetCurrentStyle("Single8")
				end
			end
		end
	end
end

t[#t+1] = Def.ActorFrame{
	Def.Actor{ OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(input) end };
	CommonNormal()..{
		InitCommand=cmd(xy,CenterX(),Bottom()-28;zoom,0.5);
		OnCommand=function(self)
			if GAMESTATE:GetNumSidesJoined() > 0 then
				self:settext(string.upper("Press &SELECT; to Create a new Profile"))
			else
				self:settext(string.upper("Press &START; to Join!"))
			end
		end;
		PlayerJoinedMessageCommand=cmd(playcommand,"On");
	};
};

return t